using System;
using System.Text;
using System.Windows.Forms;
using Borland.Eco.Services;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using System.Collections.Specialized;
using Borland.Eco.Persistence.ORMapping;
using Borland.Eco.UmlCodeAttributes;

namespace Ecoyee
{
	[EcoSpace]
	[EcoSpacePackage(typeof(Ecoyee.CoreClassesPackage))]
	public class EcoyeeSpace: Borland.Eco.Handles.DefaultEcoSpace
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Data.Provider.BdpConnection EmployeeConnection1;
		public Borland.Eco.Persistence.PersistenceMapperBdp persistenceMapperBdp1;
		private Borland.Eco.Persistence.ORMapping.FileMappingProvider ecoyeeMappingProvider;

		private void InitializeComponent()
		{
			Borland.Eco.Persistence.Configuration.KeyMapperDefinition keyMapperDefinition11 = new Borland.Eco.Persistence.Configuration.KeyMapperDefinition();
			Borland.Eco.Persistence.Configuration.KeyMapperDefinition keyMapperDefinition12 = new Borland.Eco.Persistence.Configuration.KeyMapperDefinition();
			Borland.Eco.Persistence.Configuration.KeyMapperDefinition keyMapperDefinition13 = new Borland.Eco.Persistence.Configuration.KeyMapperDefinition();
			Borland.Eco.Persistence.Configuration.KeyMapperDefinition keyMapperDefinition14 = new Borland.Eco.Persistence.Configuration.KeyMapperDefinition();
			Borland.Eco.Persistence.Configuration.KeyMapperDefinition keyMapperDefinition15 = new Borland.Eco.Persistence.Configuration.KeyMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition11 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition12 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition13 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition14 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition15 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition16 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition17 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition18 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition19 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition110 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition111 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition112 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition113 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition114 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition115 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition116 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition117 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition118 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition persistenceMapperDefinition119 = new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition();
			this.EmployeeConnection1 = new Borland.Data.Provider.BdpConnection();
			this.persistenceMapperBdp1 = new Borland.Eco.Persistence.PersistenceMapperBdp();
			this.ecoyeeMappingProvider = new Borland.Eco.Persistence.ORMapping.FileMappingProvider();
			// 
			// EmployeeConnection1
			// 
			this.EmployeeConnection1.ConnectionOptions = "waitonlocks=False;commitretain=False;sqldialect=3;transaction iso" +  
				"lation=ReadCommitted;servercharset=;rolename=myrole";
			this.EmployeeConnection1.ConnectionString = "database=C:\\Program Files\\Borland\\InterBase\\examples\\database\\emp" +  
				"loyee.gdb;assembly=Borland.Data.Interbase;vendorclient=gds32.dll;" +  
				"provider=Interbase;username=sysdba;password=masterkey";
			// 
			// persistenceMapperBdp1
			// 
			this.persistenceMapperBdp1.CompatibilityMode = Borland.Eco.Persistence.ORMapping.EcoCompatibilityMode.EcoIII;
			this.persistenceMapperBdp1.Connection = this.EmployeeConnection1;
			this.persistenceMapperBdp1.RunTimeMappingProvider = this.ecoyeeMappingProvider;
			this.persistenceMapperBdp1.SqlDatabaseConfig.BooleanTrueLiteral = "";
			this.persistenceMapperBdp1.SqlDatabaseConfig.DateTimeFormat = "\"\'\"yyyy-MM-dd\"\'\"";
			this.persistenceMapperBdp1.SqlDatabaseConfig.DefaultDateTime = new System.DateTime(((long)(0)));
			this.persistenceMapperBdp1.SqlDatabaseConfig.DefaultStringLength = 255;
			this.persistenceMapperBdp1.SqlDatabaseConfig.DropColumnTemplate = "ALTER TABLE <TableName> DROP <ColumnName>";
			this.persistenceMapperBdp1.SqlDatabaseConfig.DropIndexTemplate = "DROP INDEX <IndexName>";
			this.persistenceMapperBdp1.SqlDatabaseConfig.DropTableTemplate = "DROP TABLE <TableName>";
			this.persistenceMapperBdp1.SqlDatabaseConfig.FetchBlockSize = 250;
			keyMapperDefinition11.Mapper = typeof(Borland.Eco.Persistence.AttributeKeyMapper);
			keyMapperDefinition11.Name = "Attribute";
			keyMapperDefinition12.Mapper = typeof(Borland.Eco.Persistence.AutoIncKeyMapper);
			keyMapperDefinition12.Name = "AutoInc";
			keyMapperDefinition13.Mapper = typeof(Borland.Eco.Persistence.AutoInc16KeyMapper);
			keyMapperDefinition13.Name = "AutoInc16";
			keyMapperDefinition14.Mapper = typeof(Borland.Eco.Persistence.DefaultEcoIdMapper);
			keyMapperDefinition14.Name = "DefaultEcoIdMapper";
			keyMapperDefinition15.Mapper = typeof(Borland.Eco.Persistence.GuidKeyMapper);
			keyMapperDefinition15.Name = "Guid";
			this.persistenceMapperBdp1.SqlDatabaseConfig.KeyMappers.AddRange(new Borland.Eco.Persistence.Configuration.KeyMapperDefinition[] {
						keyMapperDefinition11,
						keyMapperDefinition12,
						keyMapperDefinition13,
						keyMapperDefinition14,
						keyMapperDefinition15});
			this.persistenceMapperBdp1.SqlDatabaseConfig.MaxDbIdentifierLength = 31;
			this.persistenceMapperBdp1.SqlDatabaseConfig.MaxIndexNameLength = 31;
			this.persistenceMapperBdp1.SqlDatabaseConfig.MaxParamsInIdList = 20;
			persistenceMapperDefinition11.Mapper = typeof(Borland.Eco.Persistence.Default.StringAsVarChar);
			persistenceMapperDefinition11.Name = "System.String";
			persistenceMapperDefinition12.Mapper = typeof(Borland.Eco.Persistence.Default.BooleanAsInteger);
			persistenceMapperDefinition12.Name = "System.Boolean";
			persistenceMapperDefinition13.Mapper = typeof(Borland.Eco.Persistence.Default.BooleanAsYNChar);
			persistenceMapperDefinition13.Name = "BooleanAsYN";
			persistenceMapperDefinition14.Mapper = typeof(Borland.Eco.Persistence.Default.Int32AsInteger);
			persistenceMapperDefinition14.Name = "System.Int32";
			persistenceMapperDefinition15.Mapper = typeof(Borland.Eco.Persistence.Interbase.Int64AsLongInteger);
			persistenceMapperDefinition15.Name = "System.Int64";
			persistenceMapperDefinition16.Mapper = typeof(Borland.Eco.Persistence.Default.Int16AsSmallint);
			persistenceMapperDefinition16.Name = "System.Int16";
			persistenceMapperDefinition17.Mapper = typeof(Borland.Eco.Persistence.Default.ByteAsSmallInt);
			persistenceMapperDefinition17.Name = "System.Byte";
			persistenceMapperDefinition18.Mapper = typeof(Borland.Eco.Persistence.Default.DoubleAsDouble);
			persistenceMapperDefinition18.Name = "System.Double";
			persistenceMapperDefinition19.Mapper = typeof(Borland.Eco.Persistence.Default.SingleAsSingle);
			persistenceMapperDefinition19.Name = "System.Single";
			persistenceMapperDefinition110.Mapper = typeof(Borland.Eco.Persistence.Default.CharAsChar);
			persistenceMapperDefinition110.Name = "System.Char";
			persistenceMapperDefinition111.Mapper = typeof(Borland.Eco.Persistence.Interbase.DecimalAsDecimal);
			persistenceMapperDefinition111.Name = "System.Decimal";
			persistenceMapperDefinition112.Mapper = typeof(Borland.Eco.Persistence.Default.DateTimeAsTimeStamp);
			persistenceMapperDefinition112.Name = "System.DateTime";
			persistenceMapperDefinition113.Mapper = typeof(Borland.Eco.Persistence.Default.GuidAsVarChar32);
			persistenceMapperDefinition113.Name = "System.Guid";
			persistenceMapperDefinition114.Mapper = typeof(Borland.Eco.Persistence.Interbase.ByteArrayAsBdpBlob);
			persistenceMapperDefinition114.Name = "System.Byte[]";
			persistenceMapperDefinition115.Mapper = typeof(Borland.Eco.Persistence.Interbase.StringAsBdpBlob);
			persistenceMapperDefinition115.Name = "StringAsBlob";
			persistenceMapperDefinition116.Mapper = typeof(Borland.Eco.Persistence.Default.TimeSpanAsTimeStamp);
			persistenceMapperDefinition116.Name = "System.TimeSpan";
			persistenceMapperDefinition117.Mapper = typeof(Borland.Eco.Persistence.Interbase.Int32AsAutoInc);
			persistenceMapperDefinition117.Name = "AutoInc";
			persistenceMapperDefinition118.Mapper = typeof(Borland.Eco.Persistence.Interbase.Int16AsAutoInc);
			persistenceMapperDefinition118.Name = "AutoInc16";
			persistenceMapperDefinition119.Mapper = typeof(Ecoyee.OnHoldBooleanAsCharMapper);
			persistenceMapperDefinition119.Name = "OnHoldBooleanAsChar";
			this.persistenceMapperBdp1.SqlDatabaseConfig.PersistenceMappers.AddRange(new Borland.Eco.Persistence.Configuration.PersistenceMapperDefinition[] {
						persistenceMapperDefinition11,
						persistenceMapperDefinition12,
						persistenceMapperDefinition13,
						persistenceMapperDefinition14,
						persistenceMapperDefinition15,
						persistenceMapperDefinition16,
						persistenceMapperDefinition17,
						persistenceMapperDefinition18,
						persistenceMapperDefinition19,
						persistenceMapperDefinition110,
						persistenceMapperDefinition111,
						persistenceMapperDefinition112,
						persistenceMapperDefinition113,
						persistenceMapperDefinition114,
						persistenceMapperDefinition115,
						persistenceMapperDefinition116,
						persistenceMapperDefinition117,
						persistenceMapperDefinition118,
						persistenceMapperDefinition119});
			this.persistenceMapperBdp1.SqlDatabaseConfig.ReservedWords = "ACTIVE,ADD,ALL,AFTER,ALTER,AND,ANY,AS,ASC,ASCENDING,AT,AUTO,AUTOI" +  
				"NC,AVG,BASE_NAME,BEFORE,BEGIN,BETWEEN,BLOB,BOOLEAN,BOTH,BY,BYTES," +  
				"CACHE,CAST,CHAR,CHARACTER,CHECK,CHECK_POINT_LENGTH,COLLATE,COLUMN" +  
				",COMMIT,COMMITTED,COMPUTED,CONDITIONAL,CONSTRAINT,CONTAINING,COUN" +  
				"T,CREATE,CSTRING,CURRENT,CURSOR,DATABASE,DATE,DAY,DEBUG,DEC,DECIM" +  
				"AL,DECLARE,DEFAULT,DELETE,DESC,DESCENDING,DISTINCT,DO,DOMAIN,DOUB" +  
				"LE,DROP,ELSE,END,ENTRY_POINT,ESCAPE,EXCEPTION,EXECUTE,EXISTS,EXIT" +  
				",EXTERNAL,EXTRACT,FILE,FILTER,FLOAT,FOR,FOREIGN,FROM,FULL,FUNCTIO" +  
				"N,GDSCODE,GENERATOR,GEN_ID,GRANT,GROUP,GROUP_COMMIT_WAIT_TIME,HAV" +  
				"ING,HOUR,IF,IN,INT,INACTIVE,INDEX,INNER,INPUT_TYPE,INSERT,INTEGER" +  
				",INTO,IS,ISOLATION,JOIN,KEY,LONG,LENGTH,LOGFILE,LOWER,LEADING,LEF" +  
				"T,LEVEL,LIKE,LOG_BUFFER_SIZE,MANUAL,MAX,MAXIMUM_SEGMENT,MERGE,MES" +  
				"SAGE,MIN,MINUTE,MODULE_NAME,MONEY,MONTH,NAMES,NATIONAL,NATURAL,NC" +  
				"HAR,NO,NOT,NULL,NUM_LOG_BUFFERS,NUMERIC,OF,ON,ONLY,OPTION,OR,ORDE" +  
				"R,OUTER,OUTPUT_TYPE,OVERFLOW,PAGE_SIZE,PAGE,PAGES,PARAMETER,PASSW" +  
				"ORD,PLAN,POSITION,POST_EVENT,PRECISION,PROCEDURE,PROTECTED,PRIMAR" +  
				"Y,PRIVILEGES,RAW_PARTITIONS,RD,DB_KEY,READ,REAL,RECORD_VERSION,RE" +  
				"FERENCES,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,REVOKE," +  
				"RIGHT,ROLE,ROLLBACK,SECOND,SEGMENT,SELECT,SET,SHARED,SHADOW,SCHEM" +  
				"A,SINGULAR,SIZE,SMALLINT,SNAPSHOT,SOME,SORT,SQLCODE,STABILITY,STA" +  
				"RTING,STARTS,STATISTICS,SUB_TYPE,SUBSTRING,SUM,SUSPEND,TABLE,THEN" +  
				",TIME,TIMESTAMP,TIMEZONE_HOUR,TIMEZONE_MINUTE,TO,TRAILING,TRANSAC" +  
				"TION,TRIGGER,TRIM,UNCOMMITTED,UNION,UNIQUE,UPDATE,UPPER,USER,VALU" +  
				"E,VALUES,VARCHAR,VARIABLE,VARYING,VIEW,WAIT,WHEN,WHERE,WHILE,WITH" +  
				",WORK,WRITE,YE,";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SQLforNotNull = "NOT NULL";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptCommentStart = "/* ";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptCommentStop = " */";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptCommitTransaction = "COMMIT";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptRollBackTransaction = "ROLLBACK";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptSeparator = "---";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptStartTransaction = "START TRANSACTION";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SqlScriptTerminator = ";";
			this.persistenceMapperBdp1.SqlDatabaseConfig.SupportsConstraintsInCreateTable = true;
			this.persistenceMapperBdp1.SqlDatabaseConfig.SystemTablePrefix = "ECO";
			this.persistenceMapperBdp1.SqlDatabaseConfig.UseSQL92Joins = false;
			this.persistenceMapperBdp1.VersionGranularity = System.TimeSpan.Parse("00:00:01");
			// 
			// ecoyeeMappingProvider
			// 
			this.ecoyeeMappingProvider.FileName = "EcoyeeMapping.xml";
			// 
			// EcoyeeSpace
			// 
			this.PersistenceMapper = this.persistenceMapperBdp1;
		}

		public EcoyeeSpace(): base()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		private static ITypeSystemService typeSystemProvider;
		private readonly static object typeSystemLock = new object();
		public new static ITypeSystemService GetTypeSystemService()
		{
		if (typeSystemProvider == null)
				lock(typeSystemLock)
				{
					if (typeSystemProvider == null)
						typeSystemProvider = MakeTypeService(typeof(EcoyeeSpace));
				}
			return typeSystemProvider;
		}
		protected override ITypeSystemService GetTypeSystemProvider()
		{
			return EcoyeeSpace.GetTypeSystemService();
		}
		//
		// Services
		//
		public IPersistenceService PersistenceService
		{
			get { return (IPersistenceService)GetEcoService(typeof(IPersistenceService)); }
		}
		public IDirtyListService DirtyListService
		{
			get { return (IDirtyListService)GetEcoService(typeof(IDirtyListService)); }
		}
		public IUndoService UndoService
		{
			get { return (IUndoService)GetEcoService(typeof(IUndoService)); }
		}
		public ITypeSystemService TypeSystemService
		{
			get { return (ITypeSystemService)GetEcoService(typeof(ITypeSystemService)); }
		}
		public IOclService OclService
		{
			get { return (IOclService)GetEcoService(typeof(IOclService)); }
		}
		public IExtentService ExtentService
		{
			get { return (IExtentService)GetEcoService(typeof(IExtentService)); }
		}
		public IObjectFactoryService ObjectFactoryService
		{
			get { return (IObjectFactoryService)GetEcoService(typeof(IObjectFactoryService)); }
		}
		public IVariableFactoryService VariableFactoryService
		{
			get { return (IVariableFactoryService)GetEcoService(typeof(IVariableFactoryService)); }
		}
		//
		// Misc helper functions
		//
		public void UpdateDatabase()
		{
			if ((PersistenceService != null) && (DirtyListService != null))
			{
				IObjectList list = DirtyListService.AllDirtyObjects();
				PersistenceService.EnsureEnclosure(list);
				StringCollection messages = new StringCollection();
				foreach (IObject o in list)
					ValidateObject(o, messages);

				if (messages.Count != 0)
				{
					StringBuilder sb = new StringBuilder();
					sb.Append("Invalid objects, update not performed\n");
					foreach (string s in messages)
					{
						sb.Append(s + "\n");
					}
					MessageBox.Show(sb.ToString());
				}
				else
					PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
			}
		}
		//
		// Add user written methods here
		//

		public void ValidateXmlMapping()
		{
			ORMappingDefinition mapping = ecoyeeMappingProvider.Mapping;
			ORMappingValidator validator = new ORMappingValidator(mapping, TypeSystem, persistenceMapperBdp1.SqlDatabaseConfig);
			validator.ValidateMapping();
			StringBuilder sb = new StringBuilder();
			if (mapping.Messages.Count > 0)
			{
				foreach (string s in mapping.Messages)
				{
					sb.Append(s + "\n");
				}
				MessageBox.Show(sb.ToString());
			}
			else
				MessageBox.Show("Mapping file validated OK");

		}
		public void SetDatabaseToTestcaseDb()
		{
			this.EmployeeConnection1.ConnectionString =
				"assembly=Borland.Data.Interbase, Version=2.5.0.0, Culture=neutral, PublicKeyToken=91d62ebb5b0d1b1b;"+
				"vendorclient=gds32.dll;"+
				"database=c:\\temp\\employee.gdb;" +
				"provider=Interbase;"+
				"username=sysdba;"+
				"password=masterkey";

		}

		public bool ValidateObject(IObject o, StringCollection messages)
		{
			int oldMessages = messages.Count;
			for (int i = 0; i < o.UmlClass.EcoClass.AllStructuralFeatures.Count; i++)
			{
			  IStructuralFeature feature = o.UmlClass.EcoClass.AllStructuralFeatures[i];
			  if (feature is IAttribute)
			  {
				IAttribute attr = feature as IAttribute;
				// Check the length of strings
				if (attr.Type_.ObjectType == typeof(System.String))
				{
					string s = o.Properties[attr.Name].AsObject as System.String;
					int length = System.Int32.Parse(attr.TaggedValues.GetItemByTag("Eco.Length").Value);
					if (s.Length > length)
						messages.Add(String.Format("String property {0}.{1} is too long. Value: \"{2}\" Maxlength = {3}",
							attr.Owner.Name, attr.Name, s, length));
				}
			  }
			  if (feature is IAssociationEnd)
			  {
				IAssociationEnd assocEnd = feature as IAssociationEnd;
				IProperty prop = o.Properties[assocEnd.Name];
				// check mandatory singlelinks
				if ((prop is IObject) && (assocEnd.Multiplicity.Lower > 0) && ((prop as IObject).Count == 0))
					messages.Add(String.Format("Mandatory singlelink {0}.{1} is not set", assocEnd.Owner.Name, assocEnd.Name));
			  }
			}
			if (o.AsObject is Customer)
			{
				Customer c = o.AsObject as Customer;
				if (c.CustomerNumber <= 1000)
					messages.Add("Invalid Customer number: "+c.CustomerNumber.ToString());
			}

			if (o.AsObject is Department)
			{
				Department d = o.AsObject as Department;
				if (d.Budget <= 10000 || d.Budget > 2000000)
					messages.Add("Invalid department budget: "+d.Budget.ToString());
				if (!(d.DepartmentNumber == null ||
					 d.DepartmentNumber == "000" || (
					   String.Compare(d.DepartmentNumber, "0") > 0 &&
					   String.Compare(d.DepartmentNumber, "999") <= 0)))
					messages.Add("Invalid DepartmentNumber: "+d.DepartmentNumber.ToString());
			}
			if (o.AsObject is Sales)
			{
				Sales s = o.AsObject as Sales;
				// CHECK PONumber Starting with V
				if (!s.PoNumber.StartsWith("V"))
					messages.Add("Invalid PO Number number: "+s.PoNumber.ToString());
				if (s.ItemType != "software" &&
					s.ItemType != "hardware" &&
					s.ItemType != "other" &&
					s.ItemType != "N/A")
					messages.Add("Invalid product: "+s.ItemType);
			}
			if (o.AsObject is Employee)
			{
				Employee e = o.AsObject as Employee;
				// CHECK Salary > 0
				if (e.Salary <= 0)
					messages.Add("Invalid salary: "+e.Salary.ToString());
			}
			if (o.AsObject is Job)
			{
				Job j = o.AsObject as Job;
				// CHECK (jobgrade between 0 and 6)
				if (j.Grade < 0 || j.Grade > 6)
					messages.Add("Invalid job grade: "+j.Grade.ToString());
				// CHECK (jobcode < "99999")
				if (String.Compare(j.Code, "99999") < 0)
					messages.Add("Invalid job code: "+j.Grade.ToString());
				// CHECK MinSalary > 0
				if (j.MinSalary <= 0)
					messages.Add("Invalid minimum salary: "+j.MinSalary.ToString());
				// CHECK MaxSalary > 0
				if (j.MaxSalary <= 0)
					messages.Add("Invalid max salary: "+j.MaxSalary.ToString());
			}

			if (o.AsObject is Project)
			{
				Project p = o.AsObject as Project;
				// CHECK ProjectType
				if (p.Product != "software" &&
					p.Product != "hardware" &&
					p.Product != "other" &&
					p.Product != "N/A")
					messages.Add("Invalid product: "+p.Product);
				if (p.Id.ToUpper() != p.Id)
					messages.Add("Invalid product id (must be uppercase): "+p.Id);
			}

			if (o.AsObject is ProjectDepartmentBudget)
			{
				ProjectDepartmentBudget pdb = o.AsObject as ProjectDepartmentBudget;
				if (pdb.ProjectedBudget <= 10000 || pdb.ProjectedBudget > 2000000)
					messages.Add("Invalid projected budget: "+pdb.ProjectedBudget.ToString());
			}


			return oldMessages == messages.Count;
		}

	}
}
